/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.applets;

import coldfusion.applets.CFGridDescription;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class CFGrid
extends JPanel {
    private final boolean m_bUsingHorizontalScrollBar;
    private final boolean m_bUsingColumnHeaders;
    private final int m_iMaxHeaderFontSize;
    private boolean m_bInited = false;
    private JTable m_table;
    private JScrollPane m_scrollPane;
    private JButton m_buttonInsert;
    private JButton m_buttonDelete;
    private JButton m_buttonSortAsc;
    private JButton m_buttonSortDsc;
    private JPanel m_panelButtons;
    public static final int BUTTON_INSERT = 1;
    public static final int BUTTON_DELETE = 2;
    public static final int BUTTON_SORT_ASC = 3;
    public static final int BUTTON_SORT_DSC = 4;
    public static final String strInsertButtonId = "insert";
    public static final String strDeleteButtonId = "delete";
    public static final String strSortAscButtonId = "sortasc";
    public static final String strSortDscButtonId = "sortdsc";

    CFGrid(CFGridDescription cFGridDescription, boolean bl) {
        this.m_bUsingHorizontalScrollBar = !bl;
        this.m_bUsingColumnHeaders = cFGridDescription.getUseColumnHeaders();
        Font font = cFGridDescription._getColumnHeaderFont(-1);
        int n = font != null ? font.getSize() : 12;
        for (int i = 0; i < cFGridDescription.getColumnCount(); ++i) {
            int n2;
            font = cFGridDescription._getColumnHeaderFont(i);
            if (font == null || (n2 = font.getSize()) <= n) continue;
            n = n2;
        }
        this.m_iMaxHeaderFontSize = n;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new EtchedBorder());
        this.m_table = new JTable();
        this.m_scrollPane = new JScrollPane(this.m_table, 20, 30);
        this.add((Component)this.m_scrollPane, "Center");
        if (cFGridDescription.hasActionBar()) {
            this.m_panelButtons = new JPanel();
            if (cFGridDescription.usingInsertButton()) {
                this.m_buttonInsert = new JButton(cFGridDescription.getInsertButtonText());
                this.m_buttonInsert.setActionCommand(strInsertButtonId);
                this.m_panelButtons.add(this.m_buttonInsert);
            }
            if (cFGridDescription.usingDeleteButton()) {
                this.m_buttonDelete = new JButton(cFGridDescription.getDeleteButtonText());
                this.m_buttonDelete.setActionCommand(strDeleteButtonId);
                this.m_panelButtons.add(this.m_buttonDelete);
            }
            if (cFGridDescription.usingSortAscendingButton()) {
                this.m_buttonSortAsc = new JButton(cFGridDescription.getSortAscendingButtonText());
                this.m_buttonSortAsc.setActionCommand(strSortAscButtonId);
                this.m_panelButtons.add(this.m_buttonSortAsc);
            }
            if (cFGridDescription.usingSortDescendingButton()) {
                this.m_buttonSortDsc = new JButton(cFGridDescription.getSortDescendingButtonText());
                this.m_buttonSortDsc.setActionCommand(strSortDscButtonId);
                this.m_panelButtons.add(this.m_buttonSortDsc);
            }
            this.add((Component)this.m_panelButtons, "South");
        }
        this.m_bInited = true;
    }

    public boolean pointInViewport(Point point) {
        if (this.m_scrollPane == null) {
            return false;
        }
        Rectangle rectangle = this.m_table.getBounds();
        Rectangle rectangle2 = this.m_scrollPane.getViewportBorderBounds();
        Point point2 = this.m_scrollPane.getViewport().getViewPosition();
        return point.x > point2.x && point.y > point2.y && point.x < Math.min(point2.x + rectangle2.width, rectangle.width) && point.y < Math.min(point2.y + rectangle2.height, rectangle.height);
    }

    public void setPreferredSize(Dimension dimension) {
        if (!this.m_bInited) {
            return;
        }
        this.setVisible(true);
        super.setSize(dimension);
        super.setPreferredSize(dimension);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setForeground(color);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setBackground(color);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setFont(font);
    }

    public Font getFont() {
        if (!this.m_bInited) {
            return super.getFont();
        }
        return this.m_table.getFont();
    }

    public void setModel(TableModel tableModel) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setModel(tableModel);
    }

    public TableModel getModel() {
        if (!this.m_bInited) {
            return null;
        }
        return this.m_table.getModel();
    }

    public TableColumnModel getColumnModel() {
        if (!this.m_bInited) {
            return null;
        }
        return this.m_table.getColumnModel();
    }

    public ListSelectionModel getSelectionModel() {
        if (!this.m_bInited) {
            return null;
        }
        return this.m_table.getSelectionModel();
    }

    public void setAutoResizeMode(int n) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setAutoResizeMode(n);
    }

    public void setShowGrid(boolean bl) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setShowGrid(bl);
    }

    public void setColumnSelectionAllowed(boolean bl) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setColumnSelectionAllowed(bl);
    }

    public void setRowSelectionAllowed(boolean bl) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setRowSelectionAllowed(bl);
    }

    public void setCellSelectionEnabled(boolean bl) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setCellSelectionEnabled(bl);
    }

    public void setSelectionBackground(Color color) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setSelectionBackground(color);
    }

    public JTableHeader getTableHeader() {
        if (!this.m_bInited) {
            return null;
        }
        return this.m_table.getTableHeader();
    }

    public void setSelectionMode(int n) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setSelectionMode(n);
    }

    public Object getValueAt(int n, int n2) {
        if (!this.m_bInited) {
            return null;
        }
        return this.m_table.getValueAt(n, n2);
    }

    public int columnAtPoint(Point point) {
        if (!this.m_bInited) {
            return -1;
        }
        return this.m_table.columnAtPoint(point);
    }

    public int getSelectedRow() {
        if (!this.m_bInited) {
            return -1;
        }
        return this.m_table.getSelectedRow();
    }

    public int getSelectedColumn() {
        if (!this.m_bInited) {
            return -1;
        }
        return this.m_table.getSelectedColumn();
    }

    public int rowAtPoint(Point point) {
        if (!this.m_bInited) {
            return -1;
        }
        return this.m_table.rowAtPoint(point);
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.addMouseListener(mouseListener);
    }

    public int getRowCount() {
        if (!this.m_bInited) {
            return 0;
        }
        return this.m_table.getRowCount();
    }

    public int getColumnCount() {
        if (!this.m_bInited) {
            return 0;
        }
        return this.m_table.getColumnCount();
    }

    public void setButtonText(int n, String string) {
        if (!this.m_bInited) {
            return;
        }
        JButton jButton = null;
        switch (n) {
            case 1: {
                jButton = this.m_buttonInsert;
                break;
            }
            case 2: {
                jButton = this.m_buttonDelete;
                break;
            }
            case 3: {
                jButton = this.m_buttonSortAsc;
                break;
            }
            case 4: {
                jButton = this.m_buttonSortDsc;
            }
        }
        if (jButton != null) {
            jButton.setText(string);
        }
    }

    public void setButtonIcon(int n, Icon icon) {
        if (!this.m_bInited) {
            return;
        }
        JButton jButton = null;
        switch (n) {
            case 1: {
                jButton = this.m_buttonInsert;
                break;
            }
            case 2: {
                jButton = this.m_buttonDelete;
                break;
            }
            case 3: {
                jButton = this.m_buttonSortAsc;
                break;
            }
            case 4: {
                jButton = this.m_buttonSortDsc;
            }
        }
        if (jButton != null && icon != null) {
            jButton.setIcon(icon);
            jButton.setText(null);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.m_bInited) {
            return;
        }
        if (this.m_buttonInsert != null) {
            this.m_buttonInsert.addActionListener(actionListener);
        }
        if (this.m_buttonDelete != null) {
            this.m_buttonDelete.addActionListener(actionListener);
        }
        if (this.m_buttonSortAsc != null) {
            this.m_buttonSortAsc.addActionListener(actionListener);
        }
        if (this.m_buttonSortDsc != null) {
            this.m_buttonSortDsc.addActionListener(actionListener);
        }
    }

    public boolean usingButton(int n) {
        if (!this.m_bInited) {
            return false;
        }
        JButton jButton = null;
        switch (n) {
            case 1: {
                jButton = this.m_buttonInsert;
                break;
            }
            case 2: {
                jButton = this.m_buttonDelete;
                break;
            }
            case 3: {
                jButton = this.m_buttonSortAsc;
                break;
            }
            case 4: {
                jButton = this.m_buttonSortDsc;
            }
        }
        return jButton != null;
    }

    public void setRowHeight(int n, int n2) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.setRowHeight(n, n2);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.scrollRectToVisible(rectangle);
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        if (!this.m_bInited) {
            return null;
        }
        return this.m_table.getCellRect(n, n2, bl);
    }

    public boolean editCellAt(int n, int n2) {
        if (!this.m_bInited) {
            return false;
        }
        return this.m_table.editCellAt(n, n2);
    }

    public int convertColumnIndexToModel(int n) {
        if (!this.m_bInited) {
            return n;
        }
        return this.m_table.convertColumnIndexToModel(n);
    }

    public boolean isEditing() {
        if (!this.m_bInited) {
            return false;
        }
        return this.m_table.isEditing();
    }

    public int getEditingColumn() {
        if (!this.m_bInited) {
            return -1;
        }
        return this.m_table.getEditingColumn();
    }

    public int getEditingRow() {
        if (!this.m_bInited) {
            return -1;
        }
        return this.m_table.getEditingRow();
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        if (!this.m_bInited) {
            return null;
        }
        return this.m_table.getCellEditor(n, n2);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (!this.m_bInited) {
            return;
        }
        this.m_table.changeSelection(n, n2, bl, bl2);
    }
}

