/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.applets;

import coldfusion.applets.CFBaseApplet;
import coldfusion.applets.CFCtrlUtils;
import coldfusion.applets.CFGrid;
import coldfusion.applets.CFGridActionListener;
import coldfusion.applets.CFGridBodyMouseListener;
import coldfusion.applets.CFGridColumnHider;
import coldfusion.applets.CFGridData;
import coldfusion.applets.CFGridDescription;
import coldfusion.applets.CFGridEditSaveMouseListener;
import coldfusion.applets.CFGridHeaderMouseListener;
import coldfusion.applets.CFGridHeaderTableCellRenderer;
import coldfusion.applets.CFGridListSelectionListener;
import coldfusion.applets.CFGridRowHeader;
import coldfusion.applets.CFGridTableCellRenderer;
import coldfusion.applets.CFGridTableModel;
import coldfusion.applets.CFGridTableModelAdapter;
import coldfusion.applets.CFGridTableSorter;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CFGridApplet
extends CFBaseApplet {
    private CFGrid m_table;
    private CFGridDescription m_gridDesc = null;
    private CFGridData m_gridData = null;
    private CFGridTableSorter m_tmSortedOnly;

    public void paint(Graphics graphics) {
        this.paintComponents(graphics);
        super.paint(graphics);
    }

    public void init() {
        Object object;
        int n;
        if (CFCtrlUtils.isInvalidJre()) {
            CFCtrlUtils.runBadJreMessage(this.getContentPane());
            return;
        }
        String string = this.getParameter("GRIDDESCRIPTION");
        if (string != null) {
            this.m_gridDesc = new CFGridDescription(string, this.getFont(), this);
        }
        this.m_gridData = new CFGridData(this.getParameter("GRIDDATA"));
        if (this.m_gridDesc == null || this.m_gridData == null) {
            return;
        }
        boolean bl = false;
        String string2 = this.getParameter("AUTOWIDTH");
        if (string2 != null) {
            bl = CFCtrlUtils.convertStrToBool(string2);
        }
        boolean bl2 = bl;
        this.m_table = new CFGrid(this.m_gridDesc, bl2);
        super.init(this.m_table);
        this.m_table.setSelectionMode(0);
        CFGridRowHeader cFGridRowHeader = new CFGridRowHeader(this.m_gridDesc);
        CFGridColumnHider cFGridColumnHider = new CFGridColumnHider();
        CFGridTableSorter cFGridTableSorter = new CFGridTableSorter();
        CFGridTableModel cFGridTableModel = new CFGridTableModel(this, this.m_gridData, this.m_gridDesc, this.m_table);
        cFGridTableSorter.setModel(cFGridTableModel);
        cFGridColumnHider.setModel(cFGridTableSorter);
        cFGridRowHeader.setModel(cFGridColumnHider);
        this.m_table.setModel(cFGridRowHeader);
        this.m_tmSortedOnly = cFGridTableSorter;
        CFGridActionListener cFGridActionListener = new CFGridActionListener(this.m_table, this.m_gridDesc);
        this.m_table.addActionListener(cFGridActionListener);
        CFGridListSelectionListener cFGridListSelectionListener = new CFGridListSelectionListener(this, this.m_table, this.m_gridDesc, this.m_tmSortedOnly);
        this.m_table.getSelectionModel().addListSelectionListener(cFGridListSelectionListener);
        this.m_table.getColumnModel().getSelectionModel().addListSelectionListener(cFGridListSelectionListener);
        CFGridEditSaveMouseListener cFGridEditSaveMouseListener = new CFGridEditSaveMouseListener(this.m_table);
        this.m_table.addMouseListener(cFGridEditSaveMouseListener);
        CFGridBodyMouseListener cFGridBodyMouseListener = new CFGridBodyMouseListener(this, this.m_table, this.m_gridDesc, this.m_tmSortedOnly);
        this.m_table.addMouseListener(cFGridBodyMouseListener);
        CFGridHeaderMouseListener cFGridHeaderMouseListener = new CFGridHeaderMouseListener(this.m_table);
        this.m_table.getTableHeader().addMouseListener(cFGridHeaderMouseListener);
        TableColumnModel tableColumnModel = this.m_table.getColumnModel();
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        DefaultTableCellRenderer defaultTableCellRenderer = null;
        for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
            object = tableColumnModel.getColumn(n);
            defaultTableCellRenderer = new CFGridTableCellRenderer(this, n, this.m_gridDesc, jTableHeader);
            ((TableColumn)object).setCellRenderer(defaultTableCellRenderer);
            defaultTableCellRenderer = new CFGridHeaderTableCellRenderer(n, this.m_gridDesc, jTableHeader);
            ((TableColumn)object).setHeaderRenderer(defaultTableCellRenderer);
        }
        this.doTableDisplayGlitchWorkAround(jTableHeader.getTable());
        if (this.m_gridDesc.getSelectMode() == 105) {
            this.doEditModeFormVariableInit(cFGridTableModel);
        }
        if (this.m_gridDesc.getSelectMode() == 105) {
            for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
                object = this.getAppropriateCellEditor(n, (CFGridTableModelAdapter)this.m_table.getModel());
                TableColumn tableColumn = tableColumnModel.getColumn(n);
                tableColumn.setCellEditor((TableCellEditor)object);
            }
        }
        this.m_table.setShowGrid(this.m_gridDesc.getGridIsVisible());
        this.setTableSelectionMode();
        this.m_table.setSelectionBackground(this.m_gridDesc.getSelectionColor());
        if (this.m_gridDesc.hasActionBar() && this.m_gridDesc.usePictures()) {
            this.setButtonImages();
        }
        this.adjustColumnWidths(tableColumnModel, (CFGridTableModelAdapter)this.m_table.getModel(), bl2);
        this.adjustRowHeight();
    }

    private void doEditModeFormVariableInit(CFGridTableModel cFGridTableModel) {
        cFGridTableModel.forceFormVariableUpdate();
    }

    private void doTableDisplayGlitchWorkAround(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableModel tableModel = jTable.getModel();
        CFGridTableModelAdapter cFGridTableModelAdapter = tableModel instanceof CFGridTableModelAdapter ? (CFGridTableModelAdapter)tableModel : null;
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)tableColumnModel.getColumn(i).getCellRenderer();
            defaultTableCellRenderer.getTableCellRendererComponent(jTable, null, false, false, 1, 0);
            if (cFGridTableModelAdapter == null || cFGridTableModelAdapter.getColumnDesc(i).getColumnType() != 5) continue;
            defaultTableCellRenderer.getTableCellRendererComponent(jTable, "cd", false, false, 1, 0);
        }
    }

    private TableCellEditor getAppropriateCellEditor(int n, CFGridTableModelAdapter cFGridTableModelAdapter) {
        Vector vector = cFGridTableModelAdapter.getColumnDesc(n).getColumnValues();
        Vector vector2 = cFGridTableModelAdapter.getColumnDesc(n).getColumnValuesDisplay();
        if (cFGridTableModelAdapter.getColumnDesc(n).getColumnType() == 7) {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setHorizontalAlignment(0);
            jCheckBox.setBackground(this.m_gridDesc.getBackgroundColor());
            return new DefaultCellEditor(jCheckBox);
        }
        if (vector != null && vector.size() > 0) {
            JComboBox<String> jComboBox = new JComboBox<String>();
            for (int i = 0; i < vector.size(); ++i) {
                if (vector2 != null && i < vector2.size()) {
                    jComboBox.addItem(new String((String)vector2.get(i)));
                    continue;
                }
                jComboBox.addItem(new String((String)vector.get(i)));
            }
            return new DefaultCellEditor(jComboBox);
        }
        return new DefaultCellEditor(new JTextField());
    }

    private void adjustRowHeight() {
        int n = this.m_gridDesc.getRowHeight();
        if (this.m_gridDesc.getRowHeight() > 0) {
            int n2 = this.m_table.getRowCount();
            for (int i = 0; i < n2; ++i) {
                this.m_table.setRowHeight(i, n);
            }
        }
    }

    private void adjustColumnWidths(TableColumnModel tableColumnModel, CFGridTableModelAdapter cFGridTableModelAdapter, boolean bl) {
        boolean bl2 = this.m_gridDesc.getUseRowHeaders();
        int n = tableColumnModel.getColumnCount();
        if (!bl) {
            this.m_table.setAutoResizeMode(0);
        }
        for (int i = 0; i < n; ++i) {
            Component component;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (i == 0 && bl2) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)tableColumn.getCellRenderer();
                component = defaultTableCellRenderer.getTableCellRendererComponent(this.m_table.getTableHeader().getTable(), null, false, false, 0, 0);
                int n2 = CFCtrlUtils.computeStringDisplayWidth("NNNN", component);
                if (n2 == -1) continue;
                tableColumn.setPreferredWidth(n2);
                continue;
            }
            int n3 = cFGridTableModelAdapter.getColumnDesc(i).getColumnWidth();
            if (n3 > 0) {
                tableColumn.setPreferredWidth(n3);
                continue;
            }
            if (bl) continue;
            component = (DefaultTableCellRenderer)tableColumn.getHeaderRenderer();
            Component component2 = component.getTableCellRendererComponent(this.m_table.getTableHeader().getTable(), null, false, false, 0, 0);
            String string = "N" + cFGridTableModelAdapter.getColumnName(i).trim() + "N";
            n3 = CFCtrlUtils.computeStringDisplayWidth(string, component2);
            if (n3 == -1) continue;
            tableColumn.setPreferredWidth(n3);
        }
    }

    private void setTableSelectionMode() {
        switch (this.m_gridDesc.getSelectMode()) {
            case 101: 
            case 105: {
                this.m_table.setCellSelectionEnabled(true);
                break;
            }
            case 102: {
                this.m_table.setCellSelectionEnabled(false);
                this.m_table.setColumnSelectionAllowed(false);
                this.m_table.setRowSelectionAllowed(true);
                break;
            }
            case 103: {
                this.m_table.setCellSelectionEnabled(false);
                this.m_table.setColumnSelectionAllowed(true);
                this.m_table.setRowSelectionAllowed(false);
                break;
            }
            case 104: {
                this.m_table.setCellSelectionEnabled(false);
                this.m_table.setColumnSelectionAllowed(false);
                this.m_table.setRowSelectionAllowed(false);
            }
        }
    }

    private void setButtonImages() {
        ImageIcon imageIcon = null;
        imageIcon = CFCtrlUtils.convertStringToImageIcon(this, "insert");
        if (imageIcon != null) {
            this.m_table.setButtonIcon(1, imageIcon);
        }
        if ((imageIcon = CFCtrlUtils.convertStringToImageIcon(this, "delete")) != null) {
            this.m_table.setButtonIcon(2, imageIcon);
        }
        if ((imageIcon = CFCtrlUtils.convertStringToImageIcon(this, "sortasc")) != null) {
            this.m_table.setButtonIcon(3, imageIcon);
        }
        if ((imageIcon = CFCtrlUtils.convertStringToImageIcon(this, "sortdesc")) != null) {
            this.m_table.setButtonIcon(4, imageIcon);
        }
    }
}

