/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.applets;

import coldfusion.applets.CFGridDescription;
import coldfusion.applets.CFGridTableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

class CFGridHeaderTableCellRenderer
extends DefaultTableCellRenderer {
    private final JTableHeader m_header;
    private final Font m_font;
    private final int m_iHorizontalAlignment;
    private final boolean m_bIsRowHeader;
    private final Color m_colorForeground;

    CFGridHeaderTableCellRenderer(int n, CFGridDescription cFGridDescription, JTableHeader jTableHeader) {
        this.m_header = jTableHeader;
        this.m_bIsRowHeader = n == 0 && cFGridDescription.getUseRowHeaders();
        TableModel tableModel = this.m_header.getTable().getModel();
        int n2 = 202;
        Font font = null;
        Color color = null;
        if (tableModel instanceof CFGridTableModelAdapter) {
            CFGridTableModelAdapter cFGridTableModelAdapter = (CFGridTableModelAdapter)tableModel;
            n2 = cFGridTableModelAdapter.getColumnDesc(n).getColumnAlignment();
            font = cFGridTableModelAdapter.getColumnDesc(n).getColumnHeaderFont();
            color = cFGridTableModelAdapter.getColumnDesc(n).getColumnHeaderTextColor();
        }
        switch (cFGridDescription.getColHeaderAlignment()) {
            case 201: {
                this.m_iHorizontalAlignment = 0;
                break;
            }
            case 203: {
                this.m_iHorizontalAlignment = 4;
                break;
            }
            default: {
                this.m_iHorizontalAlignment = 2;
            }
        }
        this.m_font = this.m_bIsRowHeader ? cFGridDescription.getRowHeaderFont() : font;
        this.m_colorForeground = color;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.m_header.getDefaultRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setHorizontalAlignment(this.m_iHorizontalAlignment);
            jLabel.setFont(this.m_font);
            if (this.m_colorForeground != null) {
                jLabel.setForeground(this.m_colorForeground);
            }
        }
        return component;
    }
}

