/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public final class URLEncoder {
    public static final String charset = "UTF-8";

    private URLEncoder() {
    }

    public static final String encode(String string) throws IOException {
        return URLEncoder.encode(string, charset);
    }

    public static final String encode(String string, String string2) throws IOException {
        if (!URLEncoder.needsEncoding(string)) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2));
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = string.charAt(i);
            if (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57 || n2 == 32) {
                if (n2 == 32) {
                    n2 = 43;
                }
                URLEncoder.toHex(stringBuffer, byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.reset();
                stringBuffer.append((char)n2);
                continue;
            }
            bufferedWriter.write(n2);
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = string.charAt(i + 1)) >= '\udc00' && c <= '\udfff') {
                bufferedWriter.write(c);
                ++i;
            }
            bufferedWriter.flush();
        }
        URLEncoder.toHex(stringBuffer, byteArrayOutputStream.toByteArray());
        return stringBuffer.toString();
    }

    private static final void toHex(StringBuffer stringBuffer, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append('%');
            char c = Character.forDigit(byArray[i] >> 4 & 0xF, 16);
            if (Character.isLetter(c)) {
                c = (char)(c - 32);
            }
            stringBuffer.append(c);
            c = Character.forDigit(byArray[i] & 0xF, 16);
            if (Character.isLetter(c)) {
                c = (char)(c - 32);
            }
            stringBuffer.append(c);
        }
    }

    private static final boolean needsEncoding(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return true;
        }
        return false;
    }
}

